#define UP 0
#define DOWN 1
#define LEFT 2
#define RIGHT 3
#define RESET 4
#define NONE 5


flash char PIC1_BMP[1024] = {
   
0x00,0xFC,0xFE,0xFE,0xFE,0x1E,0x0E,0xCE,0x0E,0x1E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x7E,0x1E,0x0E,0x0E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0x3E,0x0E,0x4E,0x4E,0xCE,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0x1E,0x0E,0x4E,0x4E,0xDE,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x9E,0x9E,0x9E,0x1E,0x9E,0xFE,0xFE,0xFE,0xFC,0x00,
0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x73,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x79,0x71,0x73,0x70,0x78,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x78,0x79,0x70,0x70,0x79,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7A,0x72,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,0x63,0x60,0x7C,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,
0x00,0xFC,0xFE,0xFE,0xFE,0x9E,0x0E,0x4E,0x0E,0x9E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x1E,0x0E,0x4E,0x0E,0x1E,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0x9E,0xCE,0x06,0x06,0xFE,0xFE,0xFE,0x0E,0x06,0xE6,0x06,0x0E,0xFC,0x00,0x00,0xFC,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x3E,0x9E,0x0E,0x0E,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x7E,0x1E,0x0E,0x0E,0xFE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0x3E,0x0E,0x4E,0x4E,0xCE,0xFE,0xFC,0x00,
0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x7B,0x72,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x78,0x78,0x7F,0x7F,0x7F,0x7C,0x78,0x79,0x78,0x7C,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x70,0x70,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x73,0x71,0x70,0x72,0x73,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x79,0x71,0x73,0x70,0x78,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x78,0x78,0x79,0x70,0x70,0x79,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7A,0x72,0x72,0x70,0x78,0x7F,0x3F,0x00,
0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x1E,0x0E,0x4E,0x4E,0xDE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xCE,0xCE,0x4E,0x0E,0xCE,0xFE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x9E,0x0E,0x4E,0x0E,0x9E,0xFC,0x00,0x00,0xFC,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0x1E,0x0E,0x4E,0x0E,0x1E,0xFC,0x00,0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x1E,0x0E,0xCE,0x0E,0x1E,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFC,0x00,0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFC,0x00,
0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x71,0x70,0x7E,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7B,0x72,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x70,0x73,0x70,0x78,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x3F,0x00,0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x79,0x71,0x73,0x70,0x78,0x3F,0x00,
0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFE,0x7E,0x1E,0x0E,0x0E,0xFE,0xFC,0x00,0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFE,0x3E,0x0E,0x4E,0x4E,0xCE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x1E,0x0E,0x4E,0x4E,0xDE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xCE,0xCE,0x4E,0x0E,0xCE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x9E,0x0E,0x4E,0x0E,0x9E,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x1E,0x0E,0x4E,0x0E,0x1E,0xFC,0x00,0x00,0xFC,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFE,0x1E,0x0E,0xCE,0x0E,0x1E,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x78,0x79,0x70,0x70,0x79,0x3F,0x00,0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x7A,0x72,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x71,0x70,0x7E,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7B,0x72,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x79,0x71,0x73,0x70,0x78,0x7F,0x78,0x70,0x73,0x70,0x78,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

};



unsigned char image_part[32];
unsigned char homes[32];		//location of every part sorted by ids
unsigned char empty_id = 31;
flash char *pic;


void glcd_drawImage(char *_pic,char x, char y){

char  i,j;


    for(j=0;j<2;j++){
        ks0108_gotoxy(0+x,j+y);;   
    for(i=0;i<16;i++)
        {
        ks0108_Write(_pic[j*16+i]);   
            }
  }

}
//this methode cut 16*16 pixel from image and
//copy it to image_part
void cut_part(flash char *pic , unsigned char id)
{
	unsigned char i , j;
	unsigned char *ptr = image_part;

	if(id == 31)
	{
		for(i = 0; i < 32; i++ , ptr++)
			*ptr = 0;
		return;
	}

	pic += ((id%8)*16) + ((id/8)*256);
	for(i = 0; i != 2 ; i++)
	{
		for(j = 0; j != 16; j++)
		{
			*ptr = *(pic);
			ptr++;
			pic++;
		}

		pic += 128-16;
	}
}

void draw_part(unsigned char id)
{
	unsigned char x , y;

	x = ((id%8) * 16);
	y = (id/8) * 2;
	glcd_drawImage(image_part , x , y);
}

void draw_all()
{
	unsigned char i;
	for(i = 0; i < 32 ; i++)
	{
		cut_part( pic , homes[i] );
		draw_part( i );
	}
}

//this method move home
char move(unsigned char side)
{
	unsigned char x ,y;
	x = empty_id%8;
	y = empty_id/8;
	switch(side)
	{
		case DOWN:
			if(y > 0)
				y--;
			else
				return 0;
			break;
		case UP:
			if(y < 3)
				y++;
			else
				return 0;
			break;
		case RIGHT:
			if(x > 0)
				x--;
			else
				return 0;
			break;
		case LEFT:
			if(x < 7)
				x++;
			else
				return 0;
	}
	
	homes[ empty_id ] = homes[ x + (y*8) ];
	homes[ x + (y*8) ] = 31;
	empty_id = x + (y*8);
	draw_all();
	return 1;
}



void beham(void)
{
	unsigned char i , t ,last=10;
	for( i = 0; i < 32; i++)
		homes[i] = i;
	draw_all();
        
	for( i = 0 ; i != 0xff; )
	{
		t = rnd(0,4);
		if( (t == UP && last != DOWN) ||
			(t == DOWN && last != UP) ||
			(t == LEFT && last != RIGHT) ||
			(t == RIGHT && last != LEFT) )
		{
			move( t );
			i++;
			last = t;
		}
	}


}

char win_puzzle(void){

char i,valid=1;

for( i = 0; i < 32; i++)
        if(homes[i] != i)
           valid=0;

if(valid==1){        //when Win
ks0108_ClearScreen();
lputsf(7,0,"You Won The Game!");
lputsf(7,2,"For New Game Press");
lputsf(40,3,"<-ENTER->");
lputsf(5,5,"Or Esc To Exit Game.");
}
return valid;
}

void run_puzzle(void){

	unsigned char i ;

start:
pic = PIC1_BMP;
play_sound(puzzle_sound);
for( i = 0; i < 32; i++)
        homes[i] = i;              
empty_id = 31; 
 draw_all();
light_on(150);
while(get_key_press(1<<BTN_EN) == 0){
      if (get_key_press(1<<BTN_MD))
            if(sound_is_play)
                stop_sound();
           else
                play_sound(puzzle_sound);
      
          if (get_key_press(1<<BTN_ES)){
          light_off(150);
                return;
        }
}
beham();

while(1){
    
      if (get_key_press(1<<BTN_MD))
            if(sound_is_play)
                stop_sound();
           else
                play_sound(puzzle_sound);
                            
    if (get_key_press(1<<BTN_UP)!=0)
    {
      paly_sound_key(key_sound);
      move(UP);
    }

    if (get_key_press(1<<BTN_DN))
    { 
    paly_sound_key(key_sound);
      move(DOWN);
    }

    if (get_key_press(1<<BTN_LT)) {
    paly_sound_key(key_sound);
      move(LEFT);
    }

    if (get_key_press(1<<BTN_RT))
    {
    paly_sound_key(key_sound);
      move(RIGHT);
    }
    
    
    if (get_key_press(1<<BTN_ES)){
        light_off(150);
        break;
        }

   if(win_puzzle()==1){
    while(1){ 


       if (get_key_press(1<<BTN_EN)){
       paly_sound_key(key_sound);
       goto start;
       } 
       
        if (get_key_press(1<<BTN_ES)){
       paly_sound_key(key_sound);
       light_off(150);
       return;
       }
    }
   
   }
}  

}

